<?php

require_once('config.php');

if(!check_admin()){
    header('Location: '.baseUrl('dashboard.php'));
    die();
}

require_once('classes/user.php');
require_once('classes/fb.php');

$fb = new Facebook();
$fb_user = $fb->get_fb_user();

$user_class = new User();
$user = $user_class->get_user();

$timezones = $user_class->timezones();

$save_user['name']              = '';
$save_user['email']             = '';
$save_user['timezone']          = 'Europe/London';
$save_user['fb_pages_limit']    = 50;
$save_user['uid']               = base64_encode(0);

if($user['id'] != base64_encode($save_user['uid']) && !$user['is_admin']){
    header('Location: '.baseUrl('dashboard.php'));
    die();
}

if(isset($_POST['edit_user']) && $_POST['edit_user'] = 'edit')
{
    $uid                = empty($_POST['uid']) ? base64_encode(0) : $_POST['uid'];

    $edit_uid = (int)base64_decode($uid);
    if($user['id'] != $edit_uid && !$user['is_admin']){
        header('Location: '.baseUrl('dashboard.php'));
        die();
    }

    $edit_user = $user_class->get_user_data($edit_uid);
    if(!empty($edit_user)){
        $save_user['name']              = $edit_user['name'];
        $save_user['email']             = $edit_user['email'];
        $save_user['timezone']          = $edit_user['timezone'];
        $save_user['fb_pages_limit']    = $edit_user['fb_pages_limit'];
        $save_user['uid']               = $uid;
    }
}

if(isset($_POST['submit']) && $_POST['submit'] = 'user')
{
    $name           = empty($_POST['name']) ? '' : $_POST['name'];
    $email          = empty($_POST['email']) ? '' : $_POST['email'];
    $password       = empty($_POST['cpassword']) ? '' : $_POST['cpassword'];
    $rpassword      = empty($_POST['repassword']) ? '' : $_POST['repassword'];
    $timezone       = empty($_POST['timezone']) ? '' : $_POST['timezone'];
    $fb_pages_limit = empty($_POST['fb_pages_limit']) ? '1' : (int)$_POST['fb_pages_limit'];
    $uid            = empty($_POST['uid']) ? base64_encode(0) : $_POST['uid'];

    if(DEMO_VERSION && $user_class->is_admin() < 2){
        $save_user['errors'][] = DEMO_ERROR;
    }else {
        $result = $user_class->create($name, $email, $password, $rpassword, $fb_pages_limit, $timezone, base64_decode($uid));
    }

    if(isset($result['success']) && $result['success']){
        header('Location: '.baseUrl('users.php'));
        die();
    }else{
        $save_user['name']              = $name;
        $save_user['email']             = $email;
        $save_user['timezone']          = $timezone;
        $save_user['fb_pages_limit']    = $fb_pages_limit;
        $save_user['uid']               = $uid;

        if(isset($result['error'])) {
            $save_user['errors'][] = $result['error'];
        }
    }


}

if((int)base64_decode($save_user['uid']) > 0){
    $save_user['title']     = 'Edit User';
    $save_user['button']    = 'EDIT USER';
}else{
    $save_user['title']     = 'Add New User';
    $save_user['button']    = 'ADD USER';
}

include('templates/add_user.php');